/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.collection;

import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDate;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfString;

public class PdfCollectionField
extends PdfObjectWrapper<PdfDictionary> {
    private static final long serialVersionUID = 4766153544105870238L;
    public static final int TEXT = 0;
    public static final int DATE = 1;
    public static final int NUMBER = 2;
    public static final int FILENAME = 3;
    public static final int DESC = 4;
    public static final int MODDATE = 5;
    public static final int CREATIONDATE = 6;
    public static final int SIZE = 7;
    protected int subType;

    protected PdfCollectionField(PdfDictionary pdfObject) {
        super(pdfObject);
        String subType;
        switch (subType = pdfObject.getAsName(PdfName.Subtype).getValue()) {
            case "D": {
                this.subType = 1;
                break;
            }
            case "N": {
                this.subType = 2;
                break;
            }
            case "F": {
                this.subType = 3;
                break;
            }
            case "Desc": {
                this.subType = 4;
                break;
            }
            case "ModDate": {
                this.subType = 5;
                break;
            }
            case "CreationDate": {
                this.subType = 6;
                break;
            }
            case "Size": {
                this.subType = 7;
                break;
            }
            default: {
                this.subType = 0;
            }
        }
    }

    public PdfCollectionField(String name, int subType) {
        super(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.N, new PdfString(name));
        this.subType = subType;
        switch (subType) {
            default: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.S);
                break;
            }
            case 1: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.D);
                break;
            }
            case 2: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.N);
                break;
            }
            case 3: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.F);
                break;
            }
            case 4: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Desc);
                break;
            }
            case 5: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.ModDate);
                break;
            }
            case 6: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.CreationDate);
                break;
            }
            case 7: {
                ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, PdfName.Size);
            }
        }
    }

    public PdfCollectionField setOrder(int order) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.O, new PdfNumber(order));
        return this;
    }

    public PdfNumber getOrder() {
        return ((PdfDictionary)this.getPdfObject()).getAsNumber(PdfName.O);
    }

    public PdfCollectionField setVisibility(boolean visible) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.V, new PdfBoolean(visible));
        return this;
    }

    public PdfBoolean getVisibility() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.V);
    }

    public PdfCollectionField setEditable(boolean editable) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.E, new PdfBoolean(editable));
        return this;
    }

    public PdfBoolean getEditable() {
        return ((PdfDictionary)this.getPdfObject()).getAsBoolean(PdfName.E);
    }

    public PdfObject getValue(String value) {
        switch (this.subType) {
            case 0: {
                return new PdfString(value);
            }
            case 1: {
                return new PdfDate(PdfDate.decode(value)).getPdfObject();
            }
            case 2: {
                return new PdfNumber(Double.parseDouble(value.trim()));
            }
        }
        throw new PdfException("{0} is not an acceptable value for the field {1}.").setMessageParams(value, ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.N).getValue());
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

